VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ScrollPlot"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private mvarPlot As New PlotPicture

Private mvarUserTop     ' top value of plot range
Private mvarUserBottom  ' bottom value of plot range
Private mvarUserLeft    ' left y axis value
Private mvarUserRight   ' right y axis value

Public Property Set PFrame(vPFrame As PictureBox)
    Set mvarPlot.PFrame = vPFrame
End Property

Public Property Let ScaleHeight(vHeight As Single)
    mvarPlot.ScaleHeight = vHeight
End Property

Public Property Let ScaleWidth(vWidth As Single)
    mvarPlot.ScaleWidth = vWidth
End Property

Public Property Let UserTop(vTop As Variant)
    mvarUserTop = vTop
End Property

Public Property Let UserBottom(vBottom As Variant)
    mvarUserBottom = vBottom
End Property

Public Property Let UserRight(vRight As Variant)
    mvarUserRight = vRight
End Property

Public Property Let UserLeft(vLeft As Variant)
    mvarUserLeft = vLeft
End Property

Public Sub Plot(vXpoint As Variant, vYPoint As Variant)
' need to convert points from user's scale to plot scale
Dim xx, yy
    If (vYPoint = "") Then vYPoint = 0
    If ((mvarUserTop - mvarUserBottom) = 0) Then
        yy = 0
    Else
        yy = ((Val(vYPoint) - mvarUserBottom) / (mvarUserTop - mvarUserBottom)) * mvarPlot.ScaleHeight
    End If
    If (yy < 0) Then
        yy = 0
    End If
    xx = ((vXpoint - mvarUserLeft) / (mvarUserRight - mvarUserLeft)) * mvarPlot.ScaleWidth
    mvarPlot.Plot xx, yy
End Sub

Public Sub PlotLine(vXpoint As Variant, vYPoint As Variant)
' need to convert points from user's scale to plot scale
Dim xx, yy
    If ((mvarUserTop - mvarUserBottom) = 0) Then
        yy = 0
    Else
        yy = ((Val(vYPoint) - mvarUserBottom) / (mvarUserTop - mvarUserBottom)) * mvarPlot.ScaleHeight
    End If
    xx = ((vXpoint - mvarUserLeft) / (mvarUserRight - mvarUserLeft)) * mvarPlot.ScaleWidth
    mvarPlot.PlotLine xx, yy

End Sub
